#!/bin/bash

#
# Copyright (c) 2001-2023 Primeton Technologies, Ltd.
# All rights reserved.
#
# @author: CHINESE (mailto:lizw@primeton.com)
#

DQMS_HOME="$(cd "$(dirname "$0")/.." && pwd)" # relative path to  absolute path

# Reference configuration
#<plugin>
#    <groupId>org.springframework.boot</groupId>
#    <artifactId>spring-boot-maven-plugin</artifactId>
#    <configuration>
#        <executable>true</executable>
#    </configuration>
#</plugin>
#

# If spring-boot fat-jar executable not enabled, or it's has been patched, set `EXECUTABLE_JAR_ENABLED=false`
export EXECUTABLE_JAR_ENABLED=false

# Path contains space not supported
# Cause: JAVA_OPTS e.g. -Dkey=value  value does not allow spaces
# Reference
# https://github.com/spring-projects/spring-boot/blob/2.1.x/spring-boot-project/spring-boot-tools/spring-boot-loader-tools/src/main/resources/org/springframework/boot/loader/tools/launch.script
# https://github.com/spring-projects/spring-boot/issues/35289 (I had been submit issue to github site.)
if [[ "$DQMS_HOME" =~ ' ' ]]; then # (( $(echo "$DQMS_HOME" | grep ' ' | wc -l) > 0 ))
  echo -e "\e[31m\e[5m[ERROR]\e[0m Do not use paths containing spaces to install programs, directory: \e[34m'${DQMS_HOME}'\e[0m . Please move the program folder to another path without spaces."
  exit 1
fi

export DQMS_HOME
export APP_NAME=GATEWAY-DEMO
export MODE=service
export LOG_FOLDER="${DQMS_HOME}"/logs
export PID_FOLDER="${LOG_FOLDER}"
export LOG_FILENAME="${APP_NAME}.out" # log console for background mode running


# validate boot JAR
if [ -z "${BOOT_JAR}" ] || [ ! -f "${BOOT_JAR}" ]; then
  [ -n "${BOOT_JAR}" ] && echo -e "\e[33m\e[5m[WARN ]\e[0m exists environment BOOT_JAR='${BOOT_JAR}', but not exists. Use automatic recognition bootstrap JAR file in directory: '${DQMS_HOME}'"
  # Automatic recognition bootstrap JAR file
  JAR_SIZE=$(find "${DQMS_HOME}" -maxdepth 1 -type f -name '*.jar' | wc -l)
  if (( "$JAR_SIZE" == 0 )); then
    echo -e "\e[31m\e[5m[ERROR]\e[0m Runnable JAR files not found in directory: '${DQMS_HOME}'. Otherwise, manually set the runnable JAR name by environment: (e.g.) export BOOT_JAR=/your/dir/boot.jar"
    exit 1
  elif (( "$JAR_SIZE" > 1 )); then
    echo -e "\e[31m\e[5m[ERROR]\e[0m Don't put other JAR files to directory: '${DQMS_HOME}'. Otherwise, manually set the runnable JAR name by environment: (e.g.) export BOOT_JAR=/your/dir/boot.jar"
    exit 1
  fi
  BOOT_JAR=$(echo "${DQMS_HOME}"/*.jar)
fi
export BOOT_JAR


[[ ! -x "${BOOT_JAR}" ]] && [[ "$EXECUTABLE_JAR_ENABLED" = 'true' ]] && chmod u+x "${BOOT_JAR}"
