## 时间线

可视化地呈现时间流信息

### **配置项**

- 数据源—数据实体

  值字段：选择时间线时间戳值字段

  显示字段：选择时间线内容值字段

  <img src="./image/timeLine0.png" alt="image-20240205092751419" style="zoom:50%;" />

- 数据源—自定义；格式必须是数组类型,数据参考如下：

  其中color指定单个节点颜色

  ```js
  [{
      content: '活动按期开始',
      timestamp: '2023-08-11 20:46',
      }, {
      content: '通过审核',
      timestamp: '2023-08-13 20:46',
      color: '#0bbd87'
      }, {
      content: '创建成功',
      timestamp: '2023-08-14 20:46',
   }]
  ```

  **时间戳字段**:指定自定义数据的时间戳字段

  **内容字段**:指定自定义数据的内容字段

- 排序

  数组是正序还是倒叙；注意不是按时间排序，是按数组的顺序

- 时间戳位置

​	时间线位于活动的上方还是下方

- 节点颜色

自定义节点颜色

- 最后一个节点颜色

自定义最后一个节点颜色

- 高级——自定义渲染模板

​	整个节点信息的自定义模板。点击开关打开，并编辑。代码参考如下：

```html
<p slot-scope="{data}">{{ data && data.content }}</p>
```

#### **案例**

效果图：

![](./image/timeLine1.jpg)

操作步骤：

- 绑定变量

  定义变量v_activities,值参考如下：

  ```json
  [{
      content: ['调研计划制定', '李瑞'],
      timestamp: '2021-12-21 00:00:00'
  },{
      content: ['运营经理审核','审核结论: 通过', '审核意见: 同意发起调研，请运营人员开展调研'],
      timestamp: '2021-12-22 00:00:00'
  }]
  ```

  ![](./image/timeLine2.jpg)

  在扩展——活动线数据(数组)绑定变量

  ![](./image/timeLine3.jpg)

- 自定义渲染模板

​	在模板中自定义代码如下：

```html
<div slot-scope="{data}">
    <div v-for="item in data.content">{{ item }}</div>
</div>
```

![](./image/timeLine4.jpg)