[TOC]

## 扩展组件配置区公共组件例子

![image-20231218142640356](./image/image-20231218142640356.png)

```javascript
<template>
  <el-form label-position="top">
    <el-form-item label="图标">
      <PmSelectIcon v-model="activeData.extConfig.icon"  placeholder="请选择图标名称" />
    </el-form-item>
    <el-form-item label="绑定变量">
      <VW v-model="activeData.datasource.test">
          <el-input
            v-model="activeData.datasource.test"
            placeholder="请输入test数据"
          />
      </VW>
    </el-form-item>
    <el-form-item label="选择字段">
      <SelectEntityField
        v-model="activeData.extConfig.fieldName"
        :show-children="true"
        :label-is-formatted="true"
        :entity-name="formConf.entityName"
        @change="fieldChanged"
      />
    </el-form-item>
    <el-form-item label="流程">
      <selectProcess @setProcessDefName="getProcessDefName" />
    </el-form-item>
    <el-form-item label="页面资源">
      <FormViewSelector
      class="w-100p"
      placeholder="页面资源"
      :view-id.sync="activeData.extConfig.viewId"
      :view-code.sync="activeData.extConfig.viewCode"
      :resource-code="formConf.resourceCode"
    />    
  </el-form-item>
  
  </el-form>
</template>
<script>
    export default {
      name:'demo-config',
      props:['activeData','formConf'],
      data(){
        return {
        }
      },
      computed:{
        
      },
      watch:{
     
      },
      methods: {
        getProcessDefName(processes){
          console.log(processes,'processes')
          this.activeData.extConfig.processDefName = processes.value
        }
      },
  }
  </script>

```

## 扩展组件抛出事件

![image-20231218142131492](./image/image-20231218142131492.png)

1.在config.js 中定义

```javascript
module.exports = {
  __config__: {
  ...
    eventTypes: [
      {
        text: "点击时",
        name: "clickCard",
        suffix: "_onClickCard",
        params: "item",
      }
    ]
  },
  ...
  };
```

2.在p c.vue 和mobile.vue 中this.$emit([name],[params])

```javascript
    <div @click="clickCard(item)"></div>
    ...
    methods:{
    clickCard(item){
      this.$emit("clickCard",item)
    }
  }

```

## 扩展组件调用低开平台Api

1.在扩展组件中定义findComponentUpward方法

```javascript
findComponentUpward(context, componentName = ["LowcodeForm",
      "lowcode_form",
      "lowcode_view",
      "LowcodeView",]){
      let parent = context.$parent
      let name = parent.$options.name
      while (parent && (!name || !componentName.some(cn => name.indexOf(cn) > -1))) {
        parent = parent.$parent
        if (parent) name = parent.$options.name
      }
      return parent
    }

```

2.在扩展组件中使用;例如关闭弹窗

```javascript
toClose(){
      this.findComponentUpward(this).Api.closeDialog()
   }
```

## 低开表单调用扩展组件内方法

1.找到扩展组件生产的代码ref

![image-20231220094751297](./image/image-20231220094751297.png)

2.调用扩展组件内的方法;例如showMessage()在扩展组件内定义的方法

```javascript
this.$refs['ref_field_77475270'].showMessage()
```

