# 面包屑组件使用说明

## 菜单路由模式

  开启后，会在页面资源作为A f c菜单时显示当前菜单名称；

## 面包屑数据

  例如如下数据格式：

  ```javascript
  [
    { value: 'home', label: '首页' },
    { value: 'manager', label: '活动管理' },
    { value: 'list', label: '活动列表' }, 
  ]
  ```

## 分割符

  指定面包屑之间的分割符

## 点击事件

  可以自定义点击单个面包屑的处理逻辑，item 为点击的面包屑信息；通常点击面包屑时，会给面包屑组件绑定的字段赋当前item.value，实现面包屑活动状态切换；  ![image-20240207095043538](./image/image-20240207095043538.png)

## 场景

点击列表一条数据编辑按钮，显示当前行内容详情，面包屑由菜单数据=》菜单数据/菜单详情(XXX)

![image-20240207100008430](./image/image-20240207100008430.png)

步骤1.定义变量v_breadcrumbList,数据如下：

```
[ {
        value: 'list',
        label: '菜单数据'
      }, {
        value: 'detail',
        label: '菜单详情'
      },{
        value: 'test',
        label: 'test'
      }
    ]
```

步骤2.字段绑定test；面包屑数据绑定v_breadcrumbList;

![image-20240207100518900](./image/image-20240207100518900.png)

步骤3.使用分组组件对面包屑组件不同活动状态显示页面内容进行切换；

![image-20240207100821450](./image/image-20240207100821450.png)

步骤4.添加自定义按钮编辑，点击列表编辑按钮时代码处理；

```javascript
console.log(formData,'formData----')
//给表单数据赋值
this.parentFormData.title= formData.title
this.parentFormData.description= formData.description
this.parentFormData.image = formData.image
this.parentFormData.__imageObject = formData.__imageObject
//面包屑组件赋值，改变活动状态和显示文字
this.parentFormData.test = "detail"
this.parent.v_breadcrumbList[1].label = `菜单详情(${formData.title})`
```

![image-20240207103031944](./image/image-20240207103031944.png)

步骤5.点击面包屑组件处理

![image-20240207095043538](./image/image-20240207095043538.png)