package com.jms;

/**
 * @author sunziren
 * @date 2023/2/17 下午 6:55
 */
import com.primeton.pmq.PMQConnectionFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

/**
 JMS生产者
 *
 @author chenyi (chenyi@primeton.com)
 */
public class Producer {
    private String url;
    private String queueName;
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Session session;
    protected Destination destination;
    protected MessageProducer producer;
    public Producer(String url, String queueName) {
        this.url = url;
        this.queueName = queueName;
    }
    /**
     初始化
     *
     */
    public void init() {
        connectionFactory = new PMQConnectionFactory(this.url);
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
            destination = session.createQueue(this.queueName);
            producer = session.createProducer(destination);
        } catch (JMSException e) {
// @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }
    /**
     发送消息
     *
     @param text
     消息体
     */
    public void sendMessage(String text) {
        try {
            Message message = session.createTextMessage(text);
            producer.send(message);
            System.out.println("发送消息 : " + text);
        } catch (JMSException e) {
// @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }
    /**
     释放资源
     *
     */
    public void close() {
        System.out.println("释放生产者资源。");
        try {
            if (producer != null) {
                producer.close();
                producer = null;
            }
            if (session != null) {
                session.close();
                session = null;
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
        } catch (JMSException e) {
// @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }
    public static void main(String[] args) {
        String url = "tcp://192.168.17.92:61616";
        String queueName = "sourceQueue";
        String text = "中介JMS穿透接口1";
        Producer producer = new Producer(url, queueName);
        producer.init();
        producer.sendMessage(text);
        producer.close();
    }
}
