package com.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

import com.primeton.pmq.PMQConnectionFactory;
import com.primeton.pmq.command.PMQBytesMessage;
import com.primeton.pmq.command.PMQTextMessage;

/**
 * @author sunziren
 * @date 2023/6/26 下午 2:21
 */
public class JmsToHttpConsumer {
    private String url;

    private String queueName;

    protected ConnectionFactory connectionFactory;

    protected Connection connection;

    protected Session session;

    protected Destination destination;

    protected MessageConsumer consumer;

    public JmsToHttpConsumer(String url, String queueName) {
        this.url = url;
        this.queueName = queueName;
    }

    /**
     * 初始化
     *
     */
    public void init() {
        connectionFactory = new PMQConnectionFactory(this.url);
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
            destination = session.createQueue(this.queueName);
            consumer = session.createConsumer(destination);
        } catch (JMSException e) {
            // @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }

    /**
     * 接收消息
     *
     */
    public void receiveMessage() {
        try {
            Message message = consumer.receive(2000);
            if (message instanceof PMQTextMessage) {
                PMQTextMessage textMessage = (PMQTextMessage) message;
                System.out.println("接收到TextMessage消息 : " + textMessage.getText());
            }else if(message instanceof PMQBytesMessage){
                PMQBytesMessage pmqBytesMessage = (PMQBytesMessage) message;
                System.out.println("接收到PMQBytesMessage消息 : " + new String(pmqBytesMessage.getContent().getData()));
            }
        } catch (JMSException e) {
            // @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }

    /**
     * 释放资源
     *
     */
    public void close() {
        System.out.println("释放消费者的资源。");
        try {
            if (consumer != null) {
                consumer.close();
                consumer = null;
            }
            if (session != null) {
                session.close();
                session = null;
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
        } catch (JMSException e) {
            // @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        String url = "tcp://192.168.16.141:61616";
        String queueName = "http2jms1";
        JmsToHttpConsumer receive = new JmsToHttpConsumer(url, queueName);
        receive.init();
        receive.receiveMessage();
        receive.close();
    }
}
