package com.jms;

/**
 * @author sunziren
 * @date 2023/2/17 下午 6:55
 */
import com.primeton.pmq.PMQConnectionFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
/**
 JMS消费者
 *
 @author chenyi (chenyi@primeton.com)
 */
public class JmsConsumer {
    private String url;
    private String queueName;
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Session session;
    protected Destination destination;
    protected MessageConsumer consumer;
    public JmsConsumer(String url, String queueName) {
        this.url = url;
        this.queueName = queueName;
    }
    /**
     初始化
     *
     */
    public void init() {
        connectionFactory = new PMQConnectionFactory(this.url);
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
            destination = session.createQueue(this.queueName);
            consumer = session.createConsumer(destination);
        } catch (JMSException e) {
// @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }
    /**
     接收消息
     *
     */
    public void receiveMessage() {
        try {
            Message message = consumer.receive(2000);
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage) message;
                System.out.println("接收到消息 : " + textMessage.getText());
            }
        } catch (JMSException e) {
// @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }
    /**
     释放资源
     *
     */
    public void close() {
        System.out.println("释放消费者的资源。");
        try {
            if (consumer != null) {
                consumer.close();
                consumer = null;
            }
            if (session != null) {
                session.close();
                session = null;
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
        } catch (JMSException e) {
// @REVIEW Auto-generated catch block
            e.printStackTrace();
        }
    }
    public static void main(String[] args) {
        String url = "tcp://192.168.17.92:61616";
        String queueName="targetQueue";
        JmsConsumer receive = new JmsConsumer(url, queueName);
        receive.init();
        receive.receiveMessage();
        receive.close();
    }
}
